--
-- HobeinPlane
-- Specialization for Hobein Plane
--
-- LS-Modsource.com
-- @author  Geri-G
-- @date  22/12/2009
--

HobeinPlane = {};

function HobeinPlane.prerequisitesPresent(specializations)
    return true;
end;

function HobeinPlane:load(xmlFile)
	self.PlaneNodeC = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Plane#indexClose"));
	self.isOpen = true;
	setVisibility(self.PlaneNodeC, self.isOpen);
end;

function HobeinPlane:delete()

end;

function HobeinPlane:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HobeinPlane:keyEvent(unicode, sym, modifier, isDown)
end;

function HobeinPlane:update(dt)	
	
	if self:getIsActive() and self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.protetor_graneleiro) then
			self.isOpen = not self.isOpen;
			setVisibility(self.PlaneNodeC, self.isOpen);
		end;
	end;


end;

function HobeinPlane:draw()
	if self.isOpen then
		g_currentMission:addExtraPrintText(g_i18n:getText("Hobein_2"),InputBinding.Hobein_Plane1);
	else
		g_currentMission:addExtraPrintText(g_i18n:getText("Hobein_1"),InputBinding.Hobein_Plane1);
	end;
end;


function HobeinPlane:onAttach(attacherVehicle)
end;

function HobeinPlane:onDetach()
end;




function HobeinPlane:onLeave()

end;


function HobeinPlane:onDeactivate()

end;

function HobeinPlane:onDeactivateSounds()

end;
