--
-- BuyableRowcropWheels
-- Specialization for Buyable Rowcrop Wheels
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - added network support, changed update to updateTick
--
-- @edit		JoXXer
-- @date		06/11/11
--
-- @edit                Wolverine for use with vehicle without animatedWheel
-- @date                20/02/2012

BuyableRowcropWheels = {};

function BuyableRowcropWheels.prerequisitesPresent(specializations)
    return true;
end;

function BuyableRowcropWheels:load(xmlFile)

	self.rowcropWheelTriggerCallback = BuyableRowcropWheels.rowcropWheelTriggerCallback;
	self.wheelDelete = BuyableRowcropWheels.wheelDelete;
	self.assembleWheels = SpecializationUtil.callSpecializationsFunction("assembleWheels");
	self.disassembleWheels = SpecializationUtil.callSpecializationsFunction("disassembleWheels");

	self.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.RowcropWheels#checkString"), "standart");
	self.usingTrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.RowcropWheels#activationTrigger"));


	addTrigger(self.usingTrigger, "rowcropWheelTriggerCallback", self);
    self.deleteListenerId = addDeleteListener(self.usingTrigger, "wheelDelete", self);

	self.belts = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.RowcropWheels#belts"));

    self.buyableRowcropWheels = {};
    local i = 0;
    while true do
        local wheelnamei = string.format("vehicle.RowcropWheels.wheel(%d)", i);
        local wheel = {};
        local wheelIndex = getXMLInt(xmlFile, wheelnamei .. "#wheelIndex");
        if wheelIndex == nil then
            break;
        end;

		wheel.wheelIndex = wheelIndex;
		wheel.node = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelnamei .. "#node"));
		wheel.transFix = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelnamei .. "#transFix"));
		wheel.savePosition = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelnamei .. "#savePosition"));
		table.insert(self.buyableRowcropWheels, wheel);
		i = i + 1;
	end;

	self.loadedCoords = nil;
	self.rowcropWheelsUser = nil;

	self.savedVehicleID = -1;
	self.shouldUpdateLater = false;
end;

function BuyableRowcropWheels:delete()
	if self.rowcropWheelsUser ~= nil then
		self.rowcropWheelsUser:onDisassembling(self);
		for _,rowcropWheel in pairs(self.buyableRowcropWheels) do
			delete(rowcropWheel.node);
			delete(rowcropWheel.transFix);
		end;
		self.buyableRowcropWheels = {};
	end;
    removeTrigger(self.usingTrigger);
end;

function BuyableRowcropWheels:wheelDelete()
    removeDeleteListener(self.usingTrigger, self.deleteListenerId);
end;

function BuyableRowcropWheels:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	if id ~= -1 then
		local rowcropWheelsUser = networkGetObject(id);
		if rowcropWheelsUser ~= nil then
			self:assembleWheels(rowcropWheelsUser, true);
		else
			self.savedVehicleID = id;
			self.shouldUpdateLater = true;
		end;
	end;
end;

function BuyableRowcropWheels:writeStream(streamId, connection)
	local idToWrite = -1;
	if self.rowcropWheelsUser ~= nil then
		idToWrite = networkGetObjectId(self.rowcropWheelsUser);
	end;
	streamWriteInt32(streamId, idToWrite);
end;

function BuyableRowcropWheels:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableRowcropWheels:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableRowcropWheels:update(dt)
end;

function BuyableRowcropWheels:updateTick(dt)

	-- try to load saved rowcropWheels
	if self.loadedCoords ~= nil then
		for k,steerable in pairs(g_currentMission.steerables) do
			local a,b,c = getWorldTranslation(steerable.rootNode);
			local distance = Utils.vector3Length(self.loadedCoords.x-a, self.loadedCoords.y-b, self.loadedCoords.z-c);
			if distance < 0.15 then
				self:assembleWheels(steerable);
				break;
			end;
		end;
		self.loadedCoords = nil;
	end;

	-- Attach wheels on client if not attached on load
	if self.shouldUpdateLater then
		local rowcropWheelsUser = networkGetObject(self.savedVehicleID);
		if rowcropWheelsUser ~= nil then
			self:assembleWheels(rowcropWheelsUser, true);
			self.shouldUpdateLater = false;
			self.savedVehicleID = -1;
		end;
	end;
end;

function BuyableRowcropWheels:draw()
end;

function BuyableRowcropWheels:rowcropWheelTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	local vehicle = g_currentMission.controlledVehicle;
	if vehicle ~= nil then
		if onEnter or onStay then
			if vehicle.rootNode == otherId then
				if vehicle.buyableWheels ~= nil then
					if vehicle.buyableWheels.checkString == self.checkString then
						if self.rowcropWheelsUser ~= nil then
							if self.rowcropWheelsUser == vehicle then
								vehicle.buyableWheels.rowcropwheelsInRange = self;
							end;
						else
							vehicle.buyableWheels.rowcropwheelsInRange = self;
						end;
					end;
				end;
			end;
		elseif onLeave then
			if otherId == vehicle.rootNode then
				if vehicle.buyableWheels ~= nil then
					vehicle.buyableWheels.rowcropwheelsInRange = nil;
				end;
			end;
		end;
	end;
end;

function BuyableRowcropWheels:assembleWheels(vehicle, noEventSend)
	BuyableWheelsAttachEvent.sendEvent(self, vehicle, noEventSend);

	if self.belts ~= nil then
		setVisibility(self.belts, false);
	end;
	if self.rowcropWheelsUser == nil then
		if vehicle.buyableWheels ~= nil then
			self.rowcropWheelsUser = vehicle;
			for l,rowcropWheel in pairs(self.buyableRowcropWheels) do
				if l == 1 then
					unlink(rowcropWheel.node);
					unlink(rowcropWheel.transFix);
					link(vehicle.wheels[1].driveNode, rowcropWheel.node);
				elseif l == 2 then
					unlink(rowcropWheel.node);
					unlink(rowcropWheel.transFix);
					link(vehicle.wheels[2].driveNode, rowcropWheel.node);
				elseif l == 3 then
					unlink(rowcropWheel.node);
					unlink(rowcropWheel.transFix);
					link(vehicle.wheels[3].driveNode, rowcropWheel.node);
				elseif l == 4 then
					unlink(rowcropWheel.node);
					unlink(rowcropWheel.transFix);
					link(vehicle.wheels[4].driveNode, rowcropWheel.node);
				end;
			end;
			self.rowcropWheelsUser:onAssembling(self);
		end;
	end;
end;

function BuyableRowcropWheels:disassembleWheels(vehicle, noEventSend)
	BuyableWheelsDetachEvent.sendEvent(self, vehicle, noEventSend);

	self.rowcropWheelsUser:onDisassembling(self);

	if self.belts ~= nil then
		setVisibility(self.belts, true);
	end;

	for k,wheel in pairs(self.buyableRowcropWheels) do
		unlink(wheel.transFix);
		unlink(wheel.node);
		setRotation(wheel.transFix, 0,0,0);
		setTranslation(wheel.transFix, 0,0,0);
		link(wheel.savePosition, wheel.transFix);
		link(wheel.transFix, wheel.node);
	end;
	self.rowcropWheelsUser = nil;
end;


function BuyableRowcropWheels:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

	if not resetVehicles then
		local valueStr = getXMLString(xmlFile, key.."#attacherCoordsRowcrop");
		if valueStr ~= nil then
			local x,y,z = Utils.getVectorFromString(valueStr);
			self.loadedCoords = {x = x,y = y,z = z};
		end;
	end;

    return BaseMission.VEHICLE_LOAD_OK;
end;

function BuyableRowcropWheels:getSaveAttributesAndNodes(nodeIdent)
    local attributes = nil;

	if self.rowcropWheelsUser ~= nil then
		local x,y,z = getWorldTranslation(self.rowcropWheelsUser.rootNode);
		attributes = 'attacherCoordsRowcrop="'.. x .. " " .. y .. " " .. z ..'"';
	end;

    return attributes, nil;
end;
