--
-- BuyableWheelsAttacher
-- Specialization for BuyableWheelsAttacher
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  23/04/10
--
-- Edited for use with all wheels
-- @edit JoXXer
-- @date 06/11/11

BuyableWheelsAttacher = {};

function BuyableWheelsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableWheelsAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");

	self.buyableWheels = {};
	self.buyableWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#buyableWheelsCheckString"), "standart");

	-- Standard wheels
	self.buyableWheels.standardWheels = nil;
	self.buyableWheels.wheelsInRange = nil;

	-- Rear dual wheels
	self.buyableWheels.rearDualWheels = nil;
	self.buyableWheels.rearDualwheelsInRange = nil;
	-- Front dual wheels
	self.buyableWheels.frontDualWheels = nil;
	self.buyableWheels.frontDualwheelsInRange = nil;
	-- Floatation wheels
	self.buyableWheels.floatationWheels = nil;
	self.buyableWheels.floatationwheelsInRange = nil;
	-- Rowcrop wheels
	self.buyableWheels.rowcropWheels = nil;
	self.buyableWheels.rowcropwheelsInRange = nil;

	-- Tractor pallets
	self.tractorPallets = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tractorPallets#index"));
end;

function BuyableWheelsAttacher:delete()
	if self.buyableWheels.standardWheels ~= nil then
		self.buyableWheels.standardWheels:disassembleWheels(self.buyableWheels);
	end;
	if self.buyableWheels.rearDualWheels ~= nil then
		self.buyableWheels.rearDualWheels:disassembleWheels(self.buyableWheels);
	end;
	if self.buyableWheels.frontDualWheels ~= nil then
		self.buyableWheels.frontDualWheels:disassembleWheels(self.buyableWheels);
	end;
	if self.buyableWheels.floatationWheels ~= nil then
		self.buyableWheels.floatationWheels:disassembleWheels(self.buyableWheels);
	end;
	if self.buyableWheels.rowcropWheels ~= nil then
		self.buyableWheels.rowcropWheels:disassembleWheels(self.buyableWheels);
	end;
end;

function BuyableWheelsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableWheelsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableWheelsAttacher:update(dt)

	if self:getIsActive() then
		if self.buyableWheels.standardWheels == nil and self.buyableWheels.floatationWheels == nil and self.buyableWheels.rowcropWheels == nil then
			self:setIgnition(0);
		end;

		local wheels = self.buyableWheels;

		if wheels.wheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_STANDARDWHEELS_ATTACH) then
					if wheels.standardWheels == nil and wheels.floatationWheels == nil and wheels.rowcropWheels == nil then
						wheels.wheelsInRange:assembleWheels(self);
					else
						if wheels.wheelsInRange.standardWheelsUser == self and wheels.rearDualWheels == nil then
							wheels.wheelsInRange:disassembleWheels(self);
						end;
					end;
				end;
			end;
		end;

		if wheels.rearDualwheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_REARDUALWHEELS_ATTACH) then
					if wheels.rearDualWheels == nil and wheels.standardWheels ~= nil then
						wheels.rearDualwheelsInRange:assembleWheels(self);
					else
						if wheels.rearDualwheelsInRange.rearDualWheelsUser == self and wheels.frontDualWheels == nil then
							wheels.rearDualwheelsInRange:disassembleWheels(self);
						end;
					end;
				end;
			end;
		end;

		if wheels.frontDualwheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_FRONTDUALWHEELS_ATTACH) then
					if wheels.frontDualWheels == nil and wheels.rearDualWheels ~= nil then
						wheels.frontDualwheelsInRange:assembleWheels(self);
					else
						if wheels.frontDualwheelsInRange.frontDualWheelsUser == self then
							wheels.frontDualwheelsInRange:disassembleWheels(self);
						end;
					end;
				end;
			end;
		end;

		if wheels.floatationwheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_FLOATATIONWHEELS_ATTACH) then
					if wheels.floatationWheels == nil and wheels.standardWheels == nil and wheels.rowcropWheels == nil then
						wheels.floatationwheelsInRange:assembleWheels(self);
					else
						if wheels.floatationwheelsInRange.floatationWheelsUser == self then
							wheels.floatationwheelsInRange:disassembleWheels(self);
						end;
					end;
				end;
			end;
		end;

		if wheels.rowcropwheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_ROWCROPWHEELS_ATTACH) then
					if wheels.rowcropWheels == nil and wheels.floatationWheels == nil and wheels.standardWheels == nil then
						wheels.rowcropwheelsInRange:assembleWheels(self);
					else
						if wheels.rowcropwheelsInRange.rowcropWheelsUser == self then
							wheels.rowcropwheelsInRange:disassembleWheels(self);
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableWheelsAttacher:draw()
	local wheels = self.buyableWheels;

	if wheels.wheelsInRange ~= nil and wheels.floatationWheels == nil and wheels.rowcropWheels == nil then
		if wheels.standardWheels ~= nil then
			if wheels.wheelsInRange.standardWheelsUser == self and wheels.rearDualWheels == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableStandardWheels_disassemble"), InputBinding.BUYABLE_STANDARDWHEELS_ATTACH);
			end;
		else
			if wheels.wheelsInRange.standardWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableStandardWheels_assemble"), InputBinding.BUYABLE_STANDARDWHEELS_ATTACH);
			end;
		end;
	end;

	if wheels.rearDualwheelsInRange ~= nil and wheels.standardWheels ~= nil then
		if wheels.rearDualWheels ~= nil then
			if wheels.rearDualwheelsInRange.rearDualWheelsUser == self and wheels.frontDualWheels == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableRearDualWheels_disassemble"), InputBinding.BUYABLE_REARDUALWHEELS_ATTACH);
			end;
		else
			if wheels.rearDualwheelsInRange.rearDualWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableRearDualWheels_assemble"), InputBinding.BUYABLE_REARDUALWHEELS_ATTACH);
			end;
		end;
	end;

	if wheels.frontDualwheelsInRange ~= nil and wheels.rearDualWheels ~= nil then
		if wheels.frontDualWheels ~= nil then
			if wheels.frontDualwheelsInRange.frontDualWheelsUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableFrontDualWheels_disassemble"), InputBinding.BUYABLE_FRONTDUALWHEELS_ATTACH);
			end;
		else
			if wheels.frontDualwheelsInRange.frontDualWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableFrontDualWheels_assemble"), InputBinding.BUYABLE_FRONTDUALWHEELS_ATTACH);
			end;
		end;
	end;

	if wheels.floatationwheelsInRange ~= nil and wheels.standardWheels == nil then
		if wheels.floatationWheels ~= nil then
			if wheels.floatationwheelsInRange.floatationWheelsUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableFloatationWheels_disassemble"), InputBinding.BUYABLE_FLOATATIONWHEELS_ATTACH);
			end;
		else
			if wheels.floatationwheelsInRange.floatationWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableFloatationWheels_assemble"), InputBinding.BUYABLE_FLOATATIONWHEELS_ATTACH);
			end;
		end;
	end;

	if wheels.rowcropwheelsInRange ~= nil and wheels.standardWheels == nil and wheels.floatationWheels == nil then
		if wheels.rowcropWheels ~= nil then
			if wheels.rowcropwheelsInRange.rowcropWheelsUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableRowcropWheels_disassemble"), InputBinding.BUYABLE_ROWCROPWHEELS_ATTACH);
			end;
		else
			if wheels.rowcropwheelsInRange.rowcropWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableRowcropWheels_assemble"), InputBinding.BUYABLE_ROWCROPWHEELS_ATTACH);
			end;
		end;
	end;

	if self.buyableWheels.standardWheels == nil and self.buyableWheels.floatationWheels == nil and self.buyableWheels.rowcropWheels == nil then
		g_currentMission:addWarning(g_i18n:getText("NO_WHEELS_ATTACHED") .. "\n" .. g_i18n:getText("NO_WHEELS_ATTACHED_EXPLAINED"));
	end;
end;
function BuyableWheelsAttacher:onLeave()
	-- Set all wheels in range to nil, if the wheels are moved while not in the vehicle
	local wheels = self.buyableWheels;

	if wheels.wheelsInRange ~= nil then
		wheels.wheelsInRange = nil;
	end;

	if wheels.rearDualwheelsInRange ~= nil then
		wheels.rearDualwheelsInRange = nil;
	end;

	if wheels.frontDualwheelsInRange ~= nil then
		wheels.frontDualwheelsInRange = nil;
	end;

	if wheels.floatationwheelsInRange ~= nil then
		wheels.floatationwheelsInRange = nil;
	end;

	if wheels.rowcropwheelsInRange ~= nil then
		wheels.rowcropwheelsInRange = nil;
	end;
end;
function BuyableWheelsAttacher:onAssembling(buyableWheels)
	if buyableWheels.standardWheelsUser ~= nil then
		self.buyableWheels.standardWheels = buyableWheels;
		setVisibility(self.tractorPallets, false);
	elseif buyableWheels.rearDualWheelsUser ~= nil then
		self.buyableWheels.rearDualWheels = buyableWheels;
	elseif buyableWheels.frontDualWheelsUser ~= nil then
		self.buyableWheels.frontDualWheels = buyableWheels;
	elseif buyableWheels.floatationWheelsUser ~= nil then
		self.buyableWheels.floatationWheels = buyableWheels;
		setVisibility(self.tractorPallets, false);
	elseif buyableWheels.rowcropWheelsUser ~= nil then
		self.buyableWheels.rowcropWheels = buyableWheels;
		setVisibility(self.tractorPallets, false);
	end;
end;

function BuyableWheelsAttacher:onDisassembling(buyableWheels)
	if buyableWheels.rearDualWheelsUser ~= nil then
		self.buyableWheels.rearDualWheels = nil;
	elseif buyableWheels.standardWheelsUser ~= nil then
		self.buyableWheels.standardWheels = nil;
		setVisibility(self.tractorPallets, true);
	elseif buyableWheels.frontDualWheelsUser ~= nil then
		self.buyableWheels.frontDualWheels = nil;
	elseif buyableWheels.floatationWheelsUser ~= nil then
		self.buyableWheels.floatationWheels = nil;
		setVisibility(self.tractorPallets, true);
	elseif buyableWheels.rowcropWheelsUser ~= nil then
		self.buyableWheels.rowcropWheels = nil;
		setVisibility(self.tractorPallets, true);
	end;
end;
