BuyableWheelsDetachEvent = {};
BuyableWheelsDetachEvent_mt = Class(BuyableWheelsDetachEvent, Event);

InitEventClass(BuyableWheelsDetachEvent, "BuyableWheelsDetachEvent");

function BuyableWheelsDetachEvent:emptyNew()
    local self = Event:new(BuyableWheelsDetachEvent_mt);
    self.className="BuyableWheelsDetachEvent";
    return self;
end;

function BuyableWheelsDetachEvent:new(vehicle, attacherVehicle)
    local self = BuyableWheelsDetachEvent:emptyNew()
    self.vehicle = vehicle;
	self.attacherVehicle = attacherVehicle;
    return self;
end;

function BuyableWheelsDetachEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	local attacherId = streamReadInt32(streamId);
	self.attacherVehicle = networkGetObject(attacherId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function BuyableWheelsDetachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, networkGetObjectId(self.attacherVehicle));
end;

function BuyableWheelsDetachEvent:run(connection)
	self.vehicle:disassembleWheels(self.attacherVehicle, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(BuyableWheelsDetachEvent:new(self.vehicle, self.attacherVehicle), nil, connection, self.object);
    end;
end;


function BuyableWheelsDetachEvent.sendEvent(vehicle, attacherVehicle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(BuyableWheelsDetachEvent:new(vehicle, attacherVehicle), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(BuyableWheelsDetachEvent:new(vehicle, attacherVehicle));
		end;
	end;
end;
