PressureWasherEnableEvent = {};
PressureWasherEnableEvent_mt = Class(PressureWasherEnableEvent, Event);

InitEventClass(PressureWasherEnableEvent, "PressureWasherEnableEvent");

function PressureWasherEnableEvent:emptyNew()
    local self = Event:new(PressureWasherEnableEvent_mt);
    self.className="PressureWasherEnableEvent";
    return self;
end;

function PressureWasherEnableEvent:new(vehicle, player)
    local self = PressureWasherEnableEvent:emptyNew()
    self.vehicle = vehicle;
	self.player = player;
    return self;
end;

function PressureWasherEnableEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	local playerId = streamReadInt32(streamId);
	self.player = networkGetObject(playerId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function PressureWasherEnableEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, networkGetObjectId(self.player));	
end;

function PressureWasherEnableEvent:run(connection)
	self.vehicle:setActiveState(self.player, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(PressureWasherEnableEvent:new(self.vehicle, self.player), nil, connection, self.object);
	end;
end;

function PressureWasherEnableEvent.sendEvent(vehicle, player, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(PressureWasherEnableEvent:new(vehicle, player), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(PressureWasherEnableEvent:new(vehicle, player));
		end;
	end;
end;