PressureWasherEvent = {};
PressureWasherEvent_mt = Class(PressureWasherEvent, Event);

InitEventClass(PressureWasherEvent, "PressureWasherEvent");

function PressureWasherEvent:emptyNew()
    local self = Event:new(PressureWasherEvent_mt);
    self.className="PressureWasherEvent";
    return self;
end;

function PressureWasherEvent:new(vehicle, washables)
    local self = PressureWasherEvent:emptyNew()
    self.vehicle = vehicle;
	self.washables = washables;
    return self;
end;

function PressureWasherEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	local count = streamReadInt8(streamId);
	self.washables = {};
	for i=1, count do
		local washableId = streamReadInt32(streamId);
		table.insert(self.washables, networkGetObject(washableId));
	end;	
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function PressureWasherEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, table.getn(self.washables));
	for _,washable in pairs(self.washables) do
		streamWriteInt32(streamId, networkGetObjectId(washable));
	end;	
end;

function PressureWasherEvent:run(connection)
	self.vehicle:washVehicles(self.washables, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(PressureWasherEvent:new(self.vehicle, self.washables), nil, connection, self.object);
	end;
end;

function PressureWasherEvent.sendEvent(vehicle, washables, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(PressureWasherEvent:new(vehicle, washables), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(PressureWasherEvent:new(vehicle, washables));
		end;
	end;
end;