-----------------------------------------
-- JD7930
-- Specialization for John Deere 7930
-- @Author         Wolverine
-- @Date           22.03.2012
-- @               Free to use and modify
-----------------------------------------

JD7930 = {};

function JD7930.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function JD7930:load(xmlFile)	

        --Pareboue--
	self.fender = {};
	self.fender.leftNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fender#leftIndex"));
	self.fender.rightNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fender#rightIndex"));
	self.fender.leftRotMax = getXMLInt(xmlFile, "vehicle.fender#leftRotMax");
	self.fender.rightRotMax = getXMLInt(xmlFile, "vehicle.fender#rightRotMax");

	-- Front wiper animation
	local wiperFrontAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiperFront#rootNode"));
    self.wiperFrontAnimCharSet = 0;
    if wiperFrontAnimRootNode ~= nil and wiperFrontAnimRootNode ~= 0 then
        self.wiperFrontAnimCharSet = getAnimCharacterSet(wiperFrontAnimRootNode);
        if self.wiperFrontAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperFrontAnimCharSet, getXMLString(xmlFile, "vehicle.wiperFront#clip"));
            assignAnimTrackClip(self.wiperFrontAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperFrontAnimCharSet, 0, true);
            local wiperFrontAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiperFront#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperFrontAnimCharSet, 0, wiperFrontAnimSpeedScale);
            self.wiperFrontAnimDuration = getAnimClipDuration(self.wiperFrontAnimCharSet, clip);
        end;
    end;

	self.isWiperFrontActive = false;
	self.finishWiperFront = true;

	-- Rear wiper animation
	local wiperBackAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiperBack#rootNode"));
    self.wiperBackAnimCharSet = 0;
    if wiperBackAnimRootNode ~= nil and wiperBackAnimRootNode ~= 0 then
        self.wiperBackAnimCharSet = getAnimCharacterSet(wiperBackAnimRootNode);
        if self.wiperBackAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperBackAnimCharSet, getXMLString(xmlFile, "vehicle.wiperBack#clip"));
            assignAnimTrackClip(self.wiperBackAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperBackAnimCharSet, 0, true);
            local wiperBackAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiperBack#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperBackAnimCharSet, 0, wiperBackAnimSpeedScale);
            self.wiperBackAnimDuration = getAnimClipDuration(self.wiperBackAnimCharSet, clip);
        end;
    end;
	self.isWiperBackActive = false;
	self.finishWiperBack = true;
	self.wiperFrontOn = false;
	self.wiperBackOn = false;
        
        -- Indicators Lever
	self.indicatorsLever = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indicatorsLever#index"));   
 
        -- Beacon Button
	self.beaconButton = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.beaconButton#index"));
        -- Warning Button
	self.warningButton = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.warningButton#index"));
        -- Speed Display
	self.speeddisplay = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.speeddisplay#index"));

	-- Dashboard indicators
	self.dashboardBattery = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardBattery#index"));
	
	      	
end;

function JD7930:delete()
end;

function JD7930:readStream(streamId, connection)	
end;

function JD7930:writeStream(streamId, connection)
end;

function JD7930:readUpdateStream(streamId, timestamp, connection)
end;

function JD7930:writeUpdateStream(streamId, connection, dirtyMask)
end;

function JD7930:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JD7930:keyEvent(unicode, sym, modifier, isDown)							
end;

function JD7930:update(dt)
	                 
	--pareboue--
	if self:getIsActive() then
		
		local x1,y1,z1 = getRotation(self.wheels[1].repr);
		if y1 < math.rad(self.fender.rightRotMax) then
			setRotation(self.fender.rightNode, 0, math.rad(10), 0);
		else
			setRotation(self.fender.rightNode, 0, 0, 0);
		end;
		
		local x2,y2,z2 = getRotation(self.wheels[2].repr);
		if y2 > math.rad(self.fender.leftRotMax) then
			setRotation(self.fender.leftNode, 0, math.rad(-10), 0);
		else
			setRotation(self.fender.leftNode, 0, 0, 0);
		end;
        end;	
end;

function JD7930:updateTick(dt) 

        if self:getIsActive() then
	    if self.ignitionMode == 0 then
		    if self.speeddisplay ~= nil then
			    setVisibility(self.speeddisplay, false);
		    end;
	    elseif self.ignitionMode == 1 then
		    if self.speeddisplay ~= nil then
			    setVisibility(self.speeddisplay, true);
		    end;
		    if self.dashboardBattery ~= nil then
			    setVisibility(self.dashboardBattery, true);
		    end;
	    elseif self.ignitionMode == 2 then
		    if self.speeddisplay ~= nil then
			    setVisibility(self.speeddisplay, true);
    		    end;
		    if self.dashboardBattery ~= nil then
			    setVisibility(self.dashboardBattery, false);
		    end;
            end;
        end;

	-- Stop wipers in correct position
	if not self.finishWiperFront then
		if getAnimTrackTime(self.wiperFrontAnimCharSet, 0) % self.wiperFrontAnimDuration <= 100 then
			setAnimTrackTime(self.wiperFrontAnimCharSet, 0, 0.0);
			disableAnimTrack(self.wiperFrontAnimCharSet, 0);
			self.finishWiperFront = true;
		end;
	end;

	if not self.finishWiperBack then
		if getAnimTrackTime(self.wiperBackAnimCharSet, 0) % self.wiperBackAnimDuration <= 100 then
			setAnimTrackTime(self.wiperBackAnimCharSet, 0, 0.0);
			disableAnimTrack(self.wiperBackAnimCharSet, 0);
			self.finishWiperBack = true;
		end;
	end;

	-- Start front wiper g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 or
	if self.wiperFrontOn then
		if not self.isWiperFrontActive then
			enableAnimTrack(self.wiperFrontAnimCharSet, 0);
			enableAnimTrack(self.wiperBackAnimCharSet, 0);
			self.isWiperFrontActive = true;
			self.isWiperBackActive = true;
		end;
		setRotation(self.wiperLever, 0, math.rad(-18), 0);
	else
		if self.isWiperFrontActive then
			self.isWiperFrontActive = false;
			self.finishWiperFront = false;
		end;
		setRotation(self.wiperLever, 0, 0, 0);
	end;

	-- Start rear wiper g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 or
	if self.wiperBackOn then
		if not self.isWiperBackActive then
			enableAnimTrack(self.wiperBackAnimCharSet, 0);
			self.isWiperBackActive = true;
		end;
	else
		if self.isWiperBackActive then
			self.isWiperBackActive = false;
			self.finishWiperBack = false;
		end;
	end;

	-- Levers rotations
	if self.indicatorsLever ~= nil then
		if not self.B3.wl then
			if self.B3.dirRight[1].a then
				setRotation(self.indicatorsLever, 0, math.rad(-10), 0);			        
			elseif self.B3.dirLeft[1].a then
				setRotation(self.indicatorsLever, 0, math.rad(10), 0);			        
			else
				setRotation(self.indicatorsLever, 0, 0, 0);			      
			end;
		else
			setRotation(self.indicatorsLever, 0, 0, 0);			
		end;
	end;

	-- Beacon Button
	if self.beaconButton ~= nil then
		if self.beaconLightsActive then
			setRotation(self.beaconButton, math.rad(57), math.rad(90), 0);
			
		else
			setRotation(self.beaconButton, math.rad(73), math.rad(90), 0);
			
		end;
	end;
	-- Warning Button
	if self.warningButton ~= nil then
		if self.B3.wl then
			setRotation(self.warningButton, 0, 0, math.rad(-15));
			
		else
			setRotation(self.warningButton, 0, 0, 0);
			
		end;
	end;
	
end;

function JD7930:draw()      		
end;

function JD7930:onEnter()  
	if self.isWiperFrontActive then
		enableAnimTrack(self.wiperFrontAnimCharSet, 0);
	end;
	if self.isWiperBackActive then
		enableAnimTrack(self.wiperBackAnimCharSet, 0);
	end;
     	
end;

function JD7930:onLeave() 

	if self.isWiperFrontActive then
		disableAnimTrack(self.wiperFrontAnimCharSet, 0);
	end;
	if self.isWiperBackActive then
		disableAnimTrack(self.wiperBackAnimCharSet, 0);
	end;       
end;
