--
-- AICutterHelper
-- Specialization for AICutterHelper
--
-- @author  	Manuel Leithner
-- @version 	v1.0
-- @date  		05/11/11
-- @history:	v1.0 - Initial version
--

AICutterHelper = {};

AICutterHelper.MAX_DISTANCE = 200;

function AICutterHelper.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function AICutterHelper:load(xmlFile)
	self.isAICutterHelperActive = false;
	self.lastActiveCam = 0;
end;

function AICutterHelper:delete()
end;

function AICutterHelper:readStream(streamId, connection)
end;

function AICutterHelper:writeStream(streamId, connection)
end;

function AICutterHelper:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AICutterHelper:keyEvent(unicode, sym, modifier, isDown)
end;

function AICutterHelper:update(dt)
	
	if self:getIsActive() then
		if self.attacherVehicle ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.TOGGLE_AI_HELPER) then
					self.isAICutterHelperActive = not self.isAICutterHelperActive;
					
					if self.isAICutterHelperActive and self.attacherVehicle.setBackupCam ~= nil and self.attacherVehicle.currentCam ~= 0 then
						self.lastActiveCam = self.attacherVehicle.currentCam
						self.attacherVehicle:setBackupCam(0);
					else
						if self.lastActiveCam ~= 0 and self.attacherVehicle.setBackupCam ~= nil and self.attacherVehicle.currentCam == 0 then
							if self.attacherVehicle.panel.isOpen then
								self.attacherVehicle:setBackupCam(self.lastActiveCam);
								self.lastActiveCam = 0;
							else
								self.lastActiveCam = 0;
							end;
						end;
					end;
				end;			
				if self.isClient and self.isAICutterHelperActive then
					-- disable cams
					if self.attacherVehicle.setBackupCam ~= nil and self.attacherVehicle.currentCam ~= 0 then
						self.attacherVehicle:setBackupCam(0);
					end;
					
					local offset = 0.2;
					local r,g,b = 1,0,0;
					local length = 20;
					local dirX, dirY, dirZ = localDirectionToWorld(self.attacherVehicle.rootNode, 0,0,1);
					local lx1,ly1,lz1 = getWorldTranslation(self.aiLeftMarker);
					local rx1,ry1,rz1 = getWorldTranslation(self.aiRightMarker);
					ly1 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, lx1, ly1, lz1) + offset;
					ry1 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, rx1, ry1, rz1) + offset;
					
					local lx2,ly2,lz2 = nil, nil, nil;
					local rx2,ry2,rz2 = nil, nil, nil;

					for i=0, math.floor(AICutterHelper.MAX_DISTANCE / length) + 2 do
						lx2 = lx1 + (dirX * length);
						ly2 = ly1 + (dirY * length);
						lz2 = lz1 + (dirZ * length);
						rx2 = rx1 + (dirX * length);
						ry2 = ry1 + (dirY * length);
						rz2 = rz1 + (dirZ * length);
					
						ly2 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, lx2, ly2, lz2) + offset;
						ry2 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, rx2, ry2, rz2) + offset;
						
						drawDebugLine(lx1, ly1, lz1, r, g, b, lx2, ly2, lz2, r, g, b);
						drawDebugLine(rx1, ry1, rz1, r, g, b, rx2, ry2, rz2, r, g, b);
						
						lx1 = lx2;
						ly1 = ly2;
						lz1 = lz2;
						rx1 = rx2;
						ry1 = ry2;
						rz1 = rz2;
					end;
				end;
			end;
		end;
	end;
end;

function AICutterHelper:updateTick(dt)
end;

function AICutterHelper:draw()
	if self.attacherVehicle ~= nil then
		if self.attacherVehicle.isAIThreshing ~= nil and self.attacherVehicle.canStartAIThreshing ~= nil then
			if not self.attacherVehicle.isAIThreshing and self.attacherVehicle:canStartAIThreshing() then
				g_currentMission:addHelpButtonText(g_i18n:getText("TOGGLE_AI_HELPER"), InputBinding.TOGGLE_AI_HELPER);
			end;
		end;
	end;
end;