--
-- DynamicUnloading
-- Specialization for DynamicUnloading
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		02/11/11
-- @history:	v1.0 - Initial version
--

DynamicUnloading = {};

function DynamicUnloading.prerequisitesPresent(specializations)
    return true;
end;

function DynamicUnloading:load(xmlFile)
	self.dynamicUnloading = {};
	self.dynamicUnloading.backup = self.grainTankUnloadingCapacity;
	self.dynamicUnloading.time = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dynamicUnloading#time"), 5) * 1000;	
	self.grainTankUnloadingCapacity = 1;
end;

function DynamicUnloading:delete()
end;

function DynamicUnloading:readStream(streamId, connection)
end;

function DynamicUnloading:writeStream(streamId, connection)
end;

function DynamicUnloading:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DynamicUnloading:keyEvent(unicode, sym, modifier, isDown)
end;

function DynamicUnloading:update(dt)
end;

function DynamicUnloading:updateTick(dt)

	if self.pipeParticleActivated then
		if self.currentPipeParticleSystem ~= nil then
			local newScale = Utils.getMovedLimitedValues({self.grainTankUnloadingCapacity}, {self.dynamicUnloading.backup}, {1}, 1, self.dynamicUnloading.time, dt, false);
			self.grainTankUnloadingCapacity = newScale[1];
			local scale = self.grainTankUnloadingCapacity / self.dynamicUnloading.backup;
			setShaderParameter(self.currentPipeParticleSystem[1].shape, "alphaScale", scale, 0, 0, 0, false);
		end;
	else
		if self.grainTankUnloadingCapacity ~= 1 then
			local newScale = Utils.getMovedLimitedValues({self.grainTankUnloadingCapacity}, {self.dynamicUnloading.backup}, {1}, 1, self.dynamicUnloading.time / 3, dt, true);
			self.grainTankUnloadingCapacity = newScale[1];
		end;
	end;
end;

function DynamicUnloading:draw()
end;