--
-- ExtendedManureSpreader
--
--
-- @author  Manuel Leithner
-- @date  18/11/14
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

ExtendedManureSpreader = {};

function ExtendedManureSpreader.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(ManureSpreader, specializations) and SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function ExtendedManureSpreader:load(xmlFile)
    self.manureSpreaderAnimation = getXMLString(xmlFile, "vehicle.manureSpreaderAnimation#name");
end;

function ExtendedManureSpreader:delete()
end;

function ExtendedManureSpreader:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ExtendedManureSpreader:keyEvent(unicode, sym, modifier, isDown)
end;

function ExtendedManureSpreader:update(dt)
end;

function ExtendedManureSpreader:updateTick(dt)
    if self:getIsActive() then
        if self.manureSpreaderAnimation ~= nil then
            if self:getIsAnimationPlaying(self.manureSpreaderAnimation) then
                for _,deformer in pairs(self.fillVolumeDeformers) do
                    deformer.deformerIsDirty = true;
                end;
            end;
        end;
    end;
end;

function ExtendedManureSpreader:draw()
end;

function ExtendedManureSpreader:onTurnedOn(noEventSend)
    if self.manureSpreaderAnimation ~= nil then
        local speed = 1;
        if self.fillLevel > 0 then
            speed = self.sprayLitersPerSecond[Fillable.FILLTYPE_MANURE] / self.fillLevel;
        end;
        self:playAnimation(self.manureSpreaderAnimation, speed, self:getAnimationTime(self.manureSpreaderAnimation), true);
    end;
end;

function ExtendedManureSpreader:onTurnedOff(noEventSend)
    if self.manureSpreaderAnimation ~= nil then
        self:playAnimation(self.manureSpreaderAnimation, -0.2, self:getAnimationTime(self.manureSpreaderAnimation), true);
    end;
end;