--
-- ExtendedSprayer
--
--
-- @author  Manuel Leithner
-- @date  25/07/13
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

ExtendedSprayer = {};

function ExtendedSprayer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function ExtendedSprayer:load(xmlFile)
    if self.isClient then
		local i=0;
		while true do
			local baseName = string.format("vehicle.sprayValves.sprayValve(%d)", i);
			local node = getXMLString(xmlFile, baseName.. "#index");
			if node == nil then
				break;
			end;

			local particle = self.sprayValves[i+1];
			ParticleSystemUtil.loadParticleSystemDesc(particle, self, xmlFile, baseName);
			i = i+1;
			ParticleSystemUtil.updateParticleSystem(particle, self, false);
		end;
	end;
end;

function ExtendedSprayer:delete()
end;

function ExtendedSprayer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ExtendedSprayer:keyEvent(unicode, sym, modifier, isDown)
end;

function ExtendedSprayer:update(dt)
end;

function ExtendedSprayer:updateTick(dt)
	if self:getIsActive() then
		if self:getIsTurnedOn() then
			for _, ps in pairs(self.sprayValves) do
				ParticleSystemUtil.updateParticleSystem(ps, self, false);
			end;
		end;
	end;
end;

function ExtendedSprayer:draw()
end;
